#pragma once

#include <yandex_io/capabilities/playback_control/interfaces/i_playback_control_capability.h>

#include <yandex_io/libs/threading/i_callback_queue.h>

#include <yandex_io/sdk/private/remoting/i_remote_object.h>
#include <yandex_io/sdk/private/remoting/i_remoting_registry.h>

namespace YandexIO {

    class PlaybackControlCapabilityProxy: public IPlaybackControlCapability,
                                          public YandexIO::IRemoteObject,
                                          public std::enable_shared_from_this<PlaybackControlCapabilityProxy> {
    public:
        PlaybackControlCapabilityProxy(std::weak_ptr<IRemotingRegistry> remotingRegistry,
                                       std::shared_ptr<quasar::ICallbackQueue> worker);
        ~PlaybackControlCapabilityProxy();

        void init();

        /// IPlaybackControlCapability implementation
        void play() override;
        void pause() override;
        void togglePlayPause(bool canRequestMusic) override;
        void rewind(std::uint32_t time) override;
        void like() override;
        void dislike() override;
        void next() override;
        void prev() override;

        /// IRemoteObject implementation
        void handleRemotingMessage(const quasar::proto::Remoting& message,
                                   std::shared_ptr<IRemotingConnection> connection) override;
        void handleRemotingConnect(std::shared_ptr<IRemotingConnection> connection) override;

    private:
        void trySendMessage(const quasar::proto::Remoting& message);

    private:
        const std::shared_ptr<quasar::ICallbackQueue> callbackQueue_;
        const std::string remoteObjectId_;
        std::shared_ptr<IRemotingConnection> connection_;
    };

} // namespace YandexIO
