#pragma once

#include <map>
#include <memory>
#include <set>
#include <string>

namespace YandexIO {

    class ISpotterCapability {
    public:
        class IListener {
        public:
            virtual ~IListener();

            virtual void onModelError(std::shared_ptr<ISpotterCapability> capability, const std::set<std::string>& spotterTypes) = 0;
            virtual void onModelSet(std::shared_ptr<ISpotterCapability> capability, const std::set<std::string>& spotterTypes) = 0;
        };

        virtual ~ISpotterCapability();

        virtual void setModelPaths(const std::map<std::string, std::string>& spotterTypeToModelPath) = 0;
        virtual void setSpotterWord(const std::string& spotterWord) = 0;

        virtual void addListener(std::weak_ptr<IListener> listener) = 0;
        virtual void removeListener(std::weak_ptr<IListener> listener) = 0;
    };

} // namespace YandexIO
