#pragma once

#include <yandex_io/capabilities/spotter/interfaces/i_spotter_capability.h>
#include <yandex_io/libs/base/named_callback_queue.h>
#include <yandex_io/protos/remoting.pb.h>

#include <yandex_io/sdk/private/remoting/i_remote_object.h>
#include <yandex_io/sdk/private/remoting/i_remoting_registry.h>

#include <memory>
#include <mutex>

namespace YandexIO {

    class SpotterCapabilityProxy
        : public ISpotterCapability,
          public YandexIO::IRemoteObject,
          public std::enable_shared_from_this<SpotterCapabilityProxy> {
    public:
        static std::shared_ptr<SpotterCapabilityProxy> createActivation(std::weak_ptr<IRemotingRegistry> remotingRegistry,
                                                                        std::shared_ptr<quasar::ICallbackQueue> worker);
        static std::shared_ptr<SpotterCapabilityProxy> createCommand(std::weak_ptr<IRemotingRegistry> remotingRegistry,
                                                                     std::shared_ptr<quasar::ICallbackQueue> worker);
        static std::shared_ptr<SpotterCapabilityProxy> createNaviOld(std::weak_ptr<IRemotingRegistry> remotingRegistry,
                                                                     std::shared_ptr<quasar::ICallbackQueue> worker);

        void init();

        ~SpotterCapabilityProxy();

        void setModelPaths(const std::map<std::string, std::string>& spotterTypeToModelPath) override;
        void setSpotterWord(const std::string& spotterWord) override;
        void addListener(std::weak_ptr<IListener> listener) override;
        void removeListener(std::weak_ptr<IListener> listener) override;

    protected:
        SpotterCapabilityProxy(std::weak_ptr<IRemotingRegistry> remotingRegistry,
                               std::shared_ptr<quasar::ICallbackQueue> worker,
                               const std::string& remoteObjectId);

        /// IRemoteObject implementation
        void handleRemotingMessage(const quasar::proto::Remoting& message,
                                   std::shared_ptr<IRemotingConnection> connection) override;
        void handleRemotingConnect(std::shared_ptr<IRemotingConnection> connection) override;

    private:
        void setModelPaths();
        void setSpotterWord();
        void callMethod(std::optional<quasar::proto::Remoting::SpotterCapabilityMethod>& method);
        void handleListenerMethod(const quasar::proto::Remoting::SpotterCapabilityListenerMethod& method);
        void notifyModelError(const std::set<std::string>& spotterTypes);
        void notifyModelSet(const std::set<std::string>& spotterTypes);

    private:
        const std::shared_ptr<quasar::ICallbackQueue> worker_;
        const std::string remoteObjectId_;
        std::shared_ptr<IRemotingConnection> connection_;

        std::optional<quasar::proto::Remoting::SpotterCapabilityMethod> setModelPaths_;
        std::optional<quasar::proto::Remoting::SpotterCapabilityMethod> setSpotterWord_;

        using WeakListener = std::weak_ptr<IListener>;
        std::set<WeakListener, std::owner_less<WeakListener>> listeners_;
    };

} // namespace YandexIO
