#pragma once

#include "interfaces/i_volume_capability.h"

#include <yandex_io/sdk/alice_volume_setter.h>

#include <yandex_io/sdk/interfaces/i_directive_handler.h>
#include <yandex_io/sdk/interfaces/i_endpoint.h>

#include <json/value.h>

#include <memory>
#include <set>
#include <string>

namespace YandexIO {

    class VolumeCapability
        : public IVolumeCapability,
          public IDirectiveHandler,
          public std::enable_shared_from_this<VolumeCapability> {
    public:
        explicit VolumeCapability(std::shared_ptr<AliceVolumeSetter> aliceVolumeSetter);

        // IVolumeCapability
        NAlice::TCapabilityHolder getState() const override;
        IDirectiveHandlerPtr getDirectiveHandler() override;
        void addListener(std::weak_ptr<IListener> wlistener) override;
        void removeListener(std::weak_ptr<IListener> wlistener) override;

        // IDirectiveHandler
        const std::string& getHandlerName() const override;
        const std::set<std::string>& getSupportedDirectiveNames() const override;
        void handleDirective(const std::shared_ptr<Directive>& directive) override;

    private:
        void handleSoundLouder();
        void handleSoundQuieter();
        void handleSoundMute();
        void handleSoundUnmute();
        void handleSoundSetLevel(const Json::Value& payload);

    private:
        const std::shared_ptr<AliceVolumeSetter> aliceVolumeSetter_;
    };

} // namespace YandexIO
