# Файл настроек устройства

`yandex_io` использует файл устройств `quasar.cfg`.

## Устройство quasar.cfg

Настройки задаются в формате JSON. Настройка представляет собой JSON-словарик, ключи которого, обычно, соответствуют различным сервисам внутри `yandex_io`. По этим различным ключам лежат настройки соовтетствующих сервисов: по ключу `alarmd` лежат настройки будильников, `telemetry` --- настройки телеметрии и т.д.

## Паттерны

В файле настроек есть особое поле `patterns` --- в нём лежат паттерны. По этому ключу должен лежать словарь только со строками в значениях.
При старте квазара из файла настроек вычитываются пары ключ-значение и все подстроки в настройках, содержащие ключ, окружённый фигурными скобками и предварённый знаком доллара, заменятся на значение.

Например, если в `patterns` лежит следующее значение:
```
"patterns": {
    "KEY": "VALUE"
}
```
, то в `quasar.cfg` все подстроки `${KEY}` заменятся на `VALUE`.

После применения преобразований с паттернами ключ `patterns` удаляется из настроек, т.ч. при выполнении программы нельзя к нему обращаться и искать там настройки --- ничего не будет.

## Сборка файлов настроек

Файл настроек предполагается генерировать во время сборки из нескольких файлов. Например, может быть один файл, в котором прописаны общие для всех платформ настройки, а во втором конкретно платформенные настройки. Тогда первый файл предполагается разделять между всеми платформами, что сильно уменьшает объём копипасты.

Сборка файла настроек осуществляется утилитой `config_tool`. Использование:

`config_tool output_file [input_files]`

Утилита по очереди сливает JSON'ы из `[input_files]` и кладёт результат в `output_file`. Порядок слияния JSON'ов слева направо: сначала сливается первый конфиг со вторым, потом результат их слияния с третьим, потом с четвёртым и т.д.

Правила слияния двух json'ов следующие:
- Если ключ есть в одном файле, а в другом нет, то он просто добавляется в итоговый файл.
- Если ключ есть в обоих файлах, то:
    - Если по ключу в обоих конфигах лежат словари, то они эти два словаря сливаются по описываемым правилам, и добавляются в итоговый json.
    - Если хотя бы один объект по этому ключу не словарь, то происходит замена одного значения на новое.
        - Т.е. если в конфиге лежат два списка, они не сконкатенируются, а один просто заменит другой.
        - При замене значений приоритетнее значения из конфига, который находится правее в списке аргументов.
