#pragma once

/*
 * Based on arch/arm/include/asm/cmpxchg.h
 *
 * Copyright (C) 2012 ARM Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef __ASM_CMPXCHG_H
    #define __ASM_CMPXCHG_H

    #include <inttypes.h>

static inline unsigned long __cmpxchg(volatile void* ptr, unsigned long old,
                                      unsigned long newval, int size)
{
    unsigned long oldval, res;

    /* prefetchw((const void *)ptr); */

    switch (size) {
        case 1:
            do {
                asm volatile("@ __cmpxchg1\n"
                             "   ldrexb  %1, [%2]\n"
                             "   mov     %0, #0\n"
                             "   teq     %1, %3\n"
                             "   strexbeq %0, %4, [%2]\n"
                             : "=&r"(res), "=&r"(oldval)
                             : "r"(ptr), "Ir"(old), "r"(newval)
                             : "memory", "cc");
            } while (res);
            break;
        case 2:
            do {
                asm volatile("@ __cmpxchg1\n"
                             "   ldrexh  %1, [%2]\n"
                             "   mov     %0, #0\n"
                             "   teq     %1, %3\n"
                             "   strexheq %0, %4, [%2]\n"
                             : "=&r"(res), "=&r"(oldval)
                             : "r"(ptr), "Ir"(old), "r"(newval)
                             : "memory", "cc");
            } while (res);
            break;
        case 4:
            do {
                asm volatile("@ __cmpxchg4\n"
                             "   ldrex   %1, [%2]\n"
                             "   mov     %0, #0\n"
                             "   teq     %1, %3\n"
                             "   strexeq %0, %4, [%2]\n"
                             : "=&r"(res), "=&r"(oldval)
                             : "r"(ptr), "Ir"(old), "r"(newval)
                             : "memory", "cc");
            } while (res);
            break;
        default:
            oldval = 0;
            break;
    }

    return oldval;
}

    #define cmpxchg(ptr, o, n)                             \
        ((__typeof__(*(ptr)))__cmpxchg((ptr),              \
                                       (unsigned long)(o), \
                                       (unsigned long)(n), \
                                       sizeof(*(ptr))))

#endif /* __ASM_CMPXCHG_H */
