/* tick_counter.cc
   Jeremy Barnes, 16 February 2007
   Copyright (c) 2007 Jeremy Barnes.  All rights reserved.

   Access to the processor's tick counter functions.
*/

#include "tick_counter.h"
#include <yandex_io/external_libs/datacratic/jml/math/xdiv.h>
#include <iostream>
#include <sys/time.h>

using namespace std;

namespace ML {

    /** The average number of ticks per second. */
    double ticks_per_second = -1.0;

    /** Number of seconds per tick */
    double seconds_per_tick = -1.0;

    namespace {

        // TODO: use clock_gettime
        double elapsed_since(const timeval& tv_start)
        {
            struct timeval tv_end;
            gettimeofday(&tv_end, 0);

            double start_sec = tv_start.tv_sec + (tv_start.tv_usec / 1000000.0);
            double end_sec = tv_end.tv_sec + (tv_end.tv_usec / 1000000.0);

            return (end_sec - start_sec);
        }

    }

    double calc_ticks_per_second(double to_elapse)
    {
        sched_yield();

        struct timeval tv;
        gettimeofday(&tv, 0);

        size_t before = ticks();

        double elapsed = 0.0;

        while ((elapsed = elapsed_since(tv)) < to_elapse) {
        }

        size_t after = ticks();

        return (after - before) / elapsed;
    }

    namespace {

        struct Init {
            Init()
            {
                ticks_per_second = calc_ticks_per_second();
                seconds_per_tick = 1.0 / ticks_per_second;
            }

        } init;

    }

} // namespace ML
