#include "async_call_source.h"

using namespace Datacratic;

AsyncCallSource::AsyncCallSource()
    : wakeupFd_(EFD_NONBLOCK)
{
    // No operations.
}

void AsyncCallSource::callAsync(Callback callback)
{
    std::lock_guard<std::mutex> lock(callbacksMutex_);
    callbacks_.push_back(std::move(callback));

    wakeupFd_.signal();
}

bool AsyncCallSource::processOne()
{
    std::vector<Callback> localCallbacks;
    std::unique_lock<std::mutex> lock(callbacksMutex_);
    localCallbacks = std::move(callbacks_);
    callbacks_.clear();
    wakeupFd_.tryRead();
    lock.unlock();

    for (auto& callback : localCallbacks)
        callback();

    return false;
}

int AsyncCallSource::selectFd() const {
    return wakeupFd_.fd();
}
