#pragma once

#include "async_event_source.h"
#include <yandex_io/external_libs/datacratic/jml/arch/wakeup_fd.h>

#include <vector>
#include <mutex>

namespace Datacratic {

    struct AsyncCallSource: public AsyncEventSource {
        typedef std::function<void()> Callback;

        AsyncCallSource();

        virtual bool processOne() override;
        virtual int selectFd() const override;
        void callAsync(Callback callback);

    private:
        ML::Wakeup_Fd wakeupFd_;
        std::mutex callbacksMutex_;
        std::vector<Callback> callbacks_;
    };

} // namespace Datacratic
