#pragma once

#include <yandex_io/interfaces/auth/i_auth_provider.h>

#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/ipc/message.h>
#include <yandex_io/libs/signals/live_data.h>
#include <yandex_io/libs/signals/signal_with_state.h>

#include <yandex_io/protos/quasar_proto.pb.h>

#include <functional>
#include <memory>
#include <optional>
#include <string>
#include <string_view>

namespace quasar {

    class AuthProvider: public IAuthProvider {
    public:
        struct ISdkContext {
            virtual ~ISdkContext() = default;
            virtual void connectToUserAccountInfoChanged(std::function<void(const std::string&, const std::string&)> onUserAccountInfoChanged) = 0;
            virtual void fireOAuthTokenIsInvalid(const std::string& token) = 0;
        };

    public:
        AuthProvider(std::shared_ptr<ipc::IIpcFactory> ipcFactory);
        AuthProvider(std::shared_ptr<ipc::IConnector> authdConnector, std::shared_ptr<ISdkContext> sdkContext); // For testing purpose only!
        ~AuthProvider() override;

        IAuthInfo& ownerAuthInfo() override;
        IUsersAuthInfo& usersAuthInfo() override;

        AddUserResponse addUser(const std::string& authCode, UserType userType, bool withXToken, std::chrono::milliseconds timeout) override;
        DeleteUserResponse deleteUser(int64_t id, std::chrono::milliseconds timeout) override;
        ChangeUserResponse changeUser(int64_t id, std::chrono::milliseconds timeout) override;
        void requestAuthTokenUpdate(std::string_view source) override;

    private:
        void onQuasarMessage(const ipc::SharedMessage& message);
        void onUserAccountInfoChanged(const std::string& authToken, const std::string& passportUid);
        void updateAuthInfoUnsafe();

        void onStartupInfo(const proto::AllStartupInfo& startupInfo);
        void onAddUser(const proto::AuthEvent& event);
        void onChangeUser(const proto::AuthEvent& event);
        void onRefreshUser(const proto::AuthEvent& event);
        void onChangeToken(const proto::AuthEvent& event);
        void onDeleteUser(const proto::AuthEvent& event);

        void updateOwnerInfo(AuthInfo2 authInfo);
        void updateAllUsers(std::string_view reason, UsersAuthInfo usersAuthInfo);

        void changeUser(AuthInfo2 authInfo, std::string_view reason);

    private:
        Lifetime lifetime_;
        const std::shared_ptr<ipc::IConnector> authdConnector_;
        const std::shared_ptr<ISdkContext> sdkContext_;

        std::mutex mutex_;
        std::optional<AuthInfo2> sdkAuthInfo_;
        std::optional<AuthInfo2> quasarAuthInfo_;

        LiveData<IAuthInfo> ownerInfo_;
        LiveData<IUsersAuthInfo> allUsersInfo_;
    };

} // namespace quasar
