#include "i_auth_provider.h"

using namespace quasar;

bool AuthInfo2::operator==(const AuthInfo2& other) const {
    return source == other.source &&
           authToken == other.authToken &&
           passportUid == other.passportUid &&
           tag == other.tag;
}

bool AuthInfo2::operator!=(const AuthInfo2& other) const {
    return !(*this == other);
}

bool AuthInfo2::isAuthorized() const {
    return !authToken.empty() && !passportUid.empty();
}

bool AuthInfo2::isSameAuth(const AuthInfo2& other) const {
    return authToken == other.authToken && passportUid == other.passportUid;
}

std::string IAuthProvider::AddUserResponse::statusName() const {
    return statusName(status);
}

std::string IAuthProvider::AddUserResponse::statusName(AddUserResponse::Status status)
{
    switch (status)
    {
        case Status::UNDEFINED:
            return "UNDEFINED";
        case Status::OK:
            return "OK";
        case Status::NO_INTERNET:
            return "NO_INTERNET";
        case Status::CODE_EXPIRED:
            return "CODE_EXPIRED";
        case Status::CRYPTO_ERROR:
            return "CRYPTO_ERROR";
        case Status::INVALID_TOKEN:
            return "INVALID_TOKEN";
        case Status::TIMEOUT:
            return "TIMEOUT";
    }
    throw std::runtime_error("Unknown IAuthProvider::AddUserResponse::Status: " + std::to_string((int)status));
}

std::string IAuthProvider::DeleteUserResponse::statusName() const {
    return statusName(status);
}

std::string IAuthProvider::DeleteUserResponse::statusName(DeleteUserResponse::Status status)
{
    switch (status)
    {
        case Status::UNDEFINED:
            return "UNDEFINED";
        case Status::OK:
            return "OK";
        case Status::WRONG_USER:
            return "WRONG_USER";
        case Status::TIMEOUT:
            return "TIMEOUT";
    }
    throw std::runtime_error("Unknown IAuthProvider::DeleteUserResponse::Status: " + std::to_string((int)status));
}

std::string IAuthProvider::ChangeUserResponse::statusName() const {
    return statusName(status);
}

std::string IAuthProvider::ChangeUserResponse::statusName(Status status)
{
    switch (status)
    {
        case Status::UNDEFINED:
            return "UNDEFINED";
        case Status::OK:
            return "OK";
        case Status::TIMEOUT:
            return "TIMEOUT";
    }
    throw std::runtime_error("Unknown IAuthProvider::ChangeUserResponse::Status: " + std::to_string((int)status));
}
