#pragma once

#include <yandex_io/libs/signals/signal_with_state.h>

namespace quasar {

    class RpcInterface {
    public:
        virtual ~RpcInterface();

        /**
         * @brief IReadySignal is triggered when ready state changed
         */
        using IReadySignal = ISignal<bool>;
        IReadySignal& readySignal();

    protected:
        virtual void setReady(bool isReady);

    private:
        SignalWithState<IReadySignal> readySignal_;
    };

} // namespace quasar
