#pragma once
#include <yandex_io/interfaces/clock_tower/i_clock_tower_provider.h>

#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/signals/live_data.h>
#include <yandex_io/libs/signals/signal.h>
#include <yandex_io/libs/signals/signal_external.h>
#include <yandex_io/protos/model_objects.pb.h>

namespace quasar {

    class ClockTowerProvider: public IClockTowerProvider {
    public:
        ClockTowerProvider(std::shared_ptr<ipc::IIpcFactory> ipcFactory);
        ClockTowerProvider(std::shared_ptr<ipc::IConnector> connector); // Only for tests purpose

    public: // IStereoPairProvider
        IClockTowerState& clockTowerState() override;
        void addClock(std::string deviceId, std::string host, int port, std::string clockId) override;
        std::map<std::string, std::chrono::nanoseconds> dumpAllClocks() const override;

    private:
        void updateClockTowerState(const proto::ClockTowerSync& clockSync);

    private:
        Lifetime lifetime_;
        const std::shared_ptr<ipc::IConnector> connector_;
        LiveData<IClockTowerState> clockTowerState_;

        mutable std::mutex mutex_;
        class Clock;
        std::shared_ptr<Clock> localClock_;
        std::map<std::string, std::shared_ptr<Clock>> remoteClocks_;
    };

} // namespace quasar
