#pragma once

#include <yandex_io/libs/signals/i_live_data.h>

#include <chrono>
#include <map>

namespace quasar {

    struct IClock {
        enum class SyncLevel {
            NONE,
            WEAK,
            STRONG,
        };
        virtual ~IClock() = default;
        virtual const std::string& deviceId() const noexcept = 0;
        virtual const std::string& host() const noexcept = 0;
        virtual int port() const noexcept = 0;
        virtual const std::string& clockId() const noexcept = 0;
        virtual std::chrono::nanoseconds now() const noexcept = 0;
        virtual std::chrono::nanoseconds diff() const noexcept = 0;
        virtual SyncLevel syncLevel() const noexcept = 0;
        virtual bool expired() const noexcept = 0;
        std::string peer() const;
        std::string syncLevelAsText() const;
    };

    struct ClockTowerState {
        std::shared_ptr<const IClock> localClock;
        std::map<std::string, std::shared_ptr<const IClock>> remoteClocks;

        bool operator==(const ClockTowerState& other) const;
        bool operator!=(const ClockTowerState& other) const;

        std::shared_ptr<const IClock> findClockById(std::string_view clockId) const;
        std::shared_ptr<const IClock> findClockByDeviceId(std::string_view deviceId) const;

        static std::shared_ptr<const ClockTowerState> createDefault();
    };

    class IClockTowerProvider {
    public:
        virtual ~IClockTowerProvider() = default;

        using IClockTowerState = ILiveData<std::shared_ptr<const ClockTowerState>>;
        virtual IClockTowerState& clockTowerState() = 0;
        virtual void addClock(std::string deviceId, std::string host, int port, std::string clockId) = 0;

        /**
         * @brief Dumps all clocks synchronously
         */
        virtual std::map<std::string, std::chrono::nanoseconds> dumpAllClocks() const = 0;
    };

} // namespace quasar
