#pragma once

#include <yandex_io/interfaces/clock_tower/i_clock_tower_provider.h>

#include <yandex_io/libs/signals/live_data.h>
#include <yandex_io/protos/quasar_proto.pb.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace quasar::mock {

    class ClockTowerProvider: public quasar::IClockTowerProvider {
    public:
        ClockTowerProvider()
            : clockTowerState_(std::make_shared<ClockTowerState>())
        {
        }

        void setClockTowerState(ClockTowerState state)
        {
            clockTowerState_ = std::make_shared<ClockTowerState>(std::move(state));
        }

    public:
        IClockTowerState& clockTowerState() override {
            return clockTowerState_;
        }
        MOCK_METHOD(void, addClock, (std::string, std::string, int, std::string), (override));
        MOCK_METHOD((std::map<std::string, std::chrono::nanoseconds>), dumpAllClocks, (), (const, override));

    private:
        LiveData<IClockTowerState> clockTowerState_;
    };

} // namespace quasar::mock
