#pragma once

#include <yandex_io/interfaces/device_state/i_device_state_provider.h>

#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/signals/live_data.h>
#include <yandex_io/libs/signals/signal_external.h>
#include <yandex_io/protos/quasar_proto_forward.h>

namespace quasar {

    class DeviceStateProvider: public IDeviceStateProvider {
    public:
        DeviceStateProvider(std::shared_ptr<ipc::IIpcFactory> ipcFactory);
        DeviceStateProvider(
            std::shared_ptr<ipc::IConnector> firstrundConnector,
            std::shared_ptr<ipc::IConnector> networkConnector,
            std::shared_ptr<ipc::IConnector> updatedConnector); // For testing purpose only!
        ~DeviceStateProvider();

        IDeviceState& deviceState() override;
        IConfigurationChangedSignal& configurationChangedSignal() override;
        INetworkStatusChangedSignal& networkStatusChangedSignal() override;
        IUpdateChangedSignal& updateChangedSignal() override;

    private:
        void onQuasarMessage(const ipc::SharedMessage& message);

    private:
        Lifetime lifetime_;
        const std::shared_ptr<ipc::IConnector> firstrundConnector_;
        const std::shared_ptr<ipc::IConnector> networkConnector_;
        const std::shared_ptr<ipc::IConnector> updatedConnector_;

        SignalExternal<IConfigurationChangedSignal> configurationChangedSignal_;
        SignalExternal<INetworkStatusChangedSignal> networkStatusChangedSignal_;
        SignalExternal<IUpdateChangedSignal> updateChangedSignal_;

        std::mutex mutex_;
        LiveData<IDeviceState> deviceState_;
    };

} // namespace quasar
