#include "i_device_state_provider.h"

#include <sstream>

namespace quasar {

    std::string DeviceState::toString() const {
        std::stringstream ss;
        switch (configuration) {
            case Configuration::UNDEFINED:
                ss << "UNDEFINED";
                break;
            case Configuration::CONFIGURING:
                ss << "CONFIGURING";
                break;
            case Configuration::CONFIGURED:
                ss << "CONFIGURED";
                break;
            default:
                ss << "UNSUPPORTED";
        }
        ss << ":";
        switch (update) {
            case Update::UNDEFINED:
                ss << "UNDEFINED";
                break;
            case Update::HAS_CRITICAL:
                ss << "HAS_CRITICAL";
                break;
            case Update::NO_CRITICAL:
                ss << "NO_CRITICAL";
                break;
            default:
                ss << "UNSUPPORTED";
        }

        return ss.str();
    }

} // namespace quasar
