#pragma once

#include "network_status.h"

#include <yandex_io/libs/signals/i_live_data.h>

#include <string>

namespace quasar {

    struct DeviceState {
        enum class Configuration {
            UNDEFINED = 0,
            CONFIGURING,
            CONFIGURED,
        };

        enum class Update {
            UNDEFINED = 0,
            HAS_CRITICAL,
            NO_CRITICAL
        };

        Configuration configuration{Configuration::UNDEFINED};
        NetworkStatus networkStatus;
        Update update{Update::UNDEFINED};

        std::string toString() const;
    };

    class IDeviceStateProvider {
    public:
        virtual ~IDeviceStateProvider() = default;

        using IDeviceState = ILiveData<std::shared_ptr<const DeviceState>>;
        virtual IDeviceState& deviceState() = 0;

        using IConfigurationChangedSignal = ISignal<std::shared_ptr<const DeviceState>>;
        virtual IConfigurationChangedSignal& configurationChangedSignal() = 0;

        using INetworkStatusChangedSignal = ISignal<std::shared_ptr<const DeviceState>>;
        virtual INetworkStatusChangedSignal& networkStatusChangedSignal() = 0;

        using IUpdateChangedSignal = ISignal<std::shared_ptr<const DeviceState>>;
        virtual IUpdateChangedSignal& updateChangedSignal() = 0;
    };

} // namespace quasar
