#pragma once

#include <yandex_io/interfaces/device_state/i_device_state_provider.h>

#include <yandex_io/libs/ipc/i_connector.h>
#include <yandex_io/libs/signals/live_data.h>
#include <yandex_io/libs/signals/signal_external.h>

namespace quasar::mock {

    class DeviceStateProvider: public IDeviceStateProvider {
    public:
        DeviceStateProvider()
            : configurationChangedSignal_([this](bool /*onConnected*/) { return std::make_tuple(deviceState_.value()); }, Lifetime::immortal)
            , networkStatusChangedSignal_([this](bool /*onConnected*/) { return std::make_tuple(deviceState_.value()); }, Lifetime::immortal)
            , updateChangedSignal_([this](bool /*onConnected*/) { return std::make_tuple(deviceState_.value()); }, Lifetime::immortal)
            , deviceState_(std::make_shared<DeviceState>())
        {
        }

        void setDeviceState(DeviceState ds) {
            auto oldDs = deviceState_.value();
            std::lock_guard lock(deviceState_);
            deviceState_ = std::make_shared<DeviceState>(ds);
            if (oldDs->configuration != ds.configuration) {
                configurationChangedSignal_.emit();
            }
            if (oldDs->networkStatus.type != ds.networkStatus.type || oldDs->networkStatus.status != ds.networkStatus.status) {
                networkStatusChangedSignal_.emit();
            }
            if (oldDs->update != ds.update) {
                updateChangedSignal_.emit();
            }
        }

        IConfigurationChangedSignal& configurationChangedSignal() override {
            return configurationChangedSignal_;
        }

        INetworkStatusChangedSignal& networkStatusChangedSignal() override {
            return networkStatusChangedSignal_;
        }

        IUpdateChangedSignal& updateChangedSignal() override {
            return updateChangedSignal_;
        }

    public: // IDeviceStateProvider
        IDeviceState& deviceState() override {
            return deviceState_;
        }

    public:
        SignalExternal<IConfigurationChangedSignal> configurationChangedSignal_;
        SignalExternal<INetworkStatusChangedSignal> networkStatusChangedSignal_;
        SignalExternal<IUpdateChangedSignal> updateChangedSignal_;

    private:
        LiveData<IDeviceState> deviceState_;
    };

    DeviceState defaultDeviceState();

} // namespace quasar::mock
