#pragma once

#include <yandex_io/interfaces/glagol/i_glagol_cluster_provider.h>

#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/signals/live_data.h>

namespace quasar {

    class GlagolClusterProvider: public IGlagolClusterProvider {
    public:
        GlagolClusterProvider(std::shared_ptr<ipc::IIpcFactory> ipcFactory);
        GlagolClusterProvider(std::shared_ptr<ipc::IConnector> glagoldConnector); // Only for tests purpose

        IDeviceList& deviceList() override;
        IPublicIp& publicIp() override;

        void send(Target target, std::string serviceName, const quasar::ipc::SharedMessage& message) override;
        void send(std::vector<std::string> targetDeviceIds, std::string serviceName, const quasar::ipc::SharedMessage& message) override;

    private:
        static std::string encodeQuasarMessage(const quasar::ipc::SharedMessage& message);

    private:
        Lifetime lifetime_;
        std::shared_ptr<ipc::IConnector> glagoldConnector_;
        LiveData<IDeviceList> deviceList_;
        LiveData<IPublicIp> publicIp_;
    };

} // namespace quasar
