#pragma once

#include <yandex_io/libs/ipc/message.h>
#include <yandex_io/libs/signals/i_live_data.h>

#include <vector>
namespace quasar {

    class IGlagolClusterProvider {
    public:
        virtual ~IGlagolClusterProvider() = default;

        using IDeviceList = ILiveData<std::shared_ptr<const std::vector<std::string>>>;
        virtual IDeviceList& deviceList() = 0;

        using IPublicIp = ILiveData<std::string>;
        virtual IPublicIp& publicIp() = 0;

        enum class Target {
            ALL,
            REMOTE
        };
        virtual void send(Target target, std::string serviceName, const quasar::ipc::SharedMessage& message) = 0;
        virtual void send(std::vector<std::string> targetDeviceIds, std::string serviceName, const quasar::ipc::SharedMessage& message) = 0;

        void send(std::string targetDeviceId, std::string serviceName, const quasar::ipc::SharedMessage& message);
    };

} // namespace quasar
