#pragma once

#include <yandex_io/interfaces/glagol/i_glagol_cluster_provider.h>

#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/signals/live_data.h>
#include <yandex_io/protos/quasar_proto.pb.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace quasar::mock {

    class GlagolClusterProvider: public quasar::IGlagolClusterProvider {
    public:
        GlagolClusterProvider()
            : deviceList_(std::make_shared<std::vector<std::string>>())
        {
        }

        void setDeviceList(std::vector<std::string> deviceList)
        {
            deviceList_ = std::make_shared<std::vector<std::string>>(std::move(deviceList));
        }

        void setPublicIp(std::string publicIp) {
            publicIp_ = std::move(publicIp);
        }

    public:
        IDeviceList& deviceList() override {
            return deviceList_;
        }

        IPublicIp& publicIp() override {
            return publicIp_;
        }

        MOCK_METHOD(void, send, (Target, std::string, const quasar::ipc::SharedMessage&), (override));
        MOCK_METHOD(void, send, (std::vector<std::string>, std::string, const quasar::ipc::SharedMessage&), (override));

    private:
        LiveData<IDeviceList> deviceList_;
        LiveData<IPublicIp> publicIp_;
    };

} // namespace quasar::mock
