#pragma once
#include <yandex_io/interfaces/multiroom/i_multiroom_provider.h>

#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/signals/live_data.h>

#include <yandex_io/protos/quasar_proto.pb.h>

namespace quasar {
    class MultiroomProvider: public IMultiroomProvider {
    public:
        MultiroomProvider(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<ipc::IIpcFactory> ipcFactory);
        MultiroomProvider(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<ipc::IConnector> multiroomConnector, std::shared_ptr<ICallbackQueue> lifecycle); // For testing purpose only!
        ~MultiroomProvider();

    public: // IMultiroomProvider
        IMultiroomState& multiroomState() override;

    private:
        void onQuasarMessage(const ipc::SharedMessage& message);
        void sendMultiroomDirective(std::function<void(proto::MultiroomDirective&)> /*filler*/);

    private:
        Lifetime lifetime_;
        const std::shared_ptr<YandexIO::IDevice> device_;
        const std::shared_ptr<ICallbackQueue> lifecycle_;
        const std::shared_ptr<ipc::IConnector> multiroomConnector_;

        LiveData<IMultiroomState> multiroomState_;
    };

} // namespace quasar
