#include "i_multiroom_provider.h"

#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/cryptography/digest.h>

using namespace quasar;

std::string MultiroomState::multiroomSessionId() const {
    return !broadcast ? "" : broadcast->masterDeviceId + ":" + broadcast->multiroomToken + ":" + std::to_string(broadcast->sessionTimestampMs);
}

std::string MultiroomState::multiroomTrackId() const {
    return !broadcast ? "" : broadcast->multiroomTrackId;
}

const char* MultiroomState::modeName(Mode mode)
{
    switch (mode) {
        case Mode::UNDEFINED:
            return "UNDEFINED";
        case Mode::NONE:
            return "NONE";
        case Mode::MASTER:
            return "MASTER";
        case Mode::SLAVE:
            return "SLAVE";
    }
    return "UNEXPECTED";
}

std::string MultiroomState::Audio::stateName() const {
    switch (state) {
        case State::IDLE:
            return "Idle";
        case State::BUFFERING:
            return "Buffering";
        case State::PAUSED:
            return "Paused";
        case State::PLAYING:
            return "Playing";
        case State::STOPPED:
            return "Stopped";
        case State::FINISHED:
            return "Finished";
        case State::FAILED:
            return "Failed";
    }
}

bool MultiroomState::Peer::operator==(const MultiroomState::Peer& other) const {
    return deviceId == other.deviceId && ipAddress == other.ipAddress;
}

std::string quasar::makeMultiroomSessionId(std::string_view deviceId, std::string_view multiroomToken, int64_t sessionTimestampMs) {
    if (deviceId.empty() || multiroomToken.empty() || sessionTimestampMs <= 0) {
        return std::string{};
    }
    return makeString(deviceId, ':', multiroomToken, ':', sessionTimestampMs);
}

std::string quasar::makeMultiroomTrackId(std::string_view url, int64_t basetime, int64_t position) {
    std::string result;
    if (!url.empty()) {
        Md5Hasher md5Hasher;
        md5Hasher.update(url);
        result = makeString(md5Hasher.finalize().hashString(Md5Hasher::Encoder::BASE58, 8), ':', basetime, ':', (position < 0 ? 0 : position));
    }
    return result;
}

std::string quasar::makeMultiroomToken(std::string vinsRequestId) {
    if (vinsRequestId.length() != 36) {
        vinsRequestId = makeUUID();
    }
    return vinsRequestId.replace(0, 8, "eeeeeeee").replace(9, 4, "0000").replace(14, 4, "0000");
}
