#pragma once
#include <yandex_io/libs/signals/i_live_data.h>

#include <json/value.h>

#include <map>
#include <vector>

namespace quasar {

    namespace proto {
        class QuasarMessage;
        class ExternalCommandMessage;
    } // namespace proto

    struct MultiroomState {
        enum class PlayingState {
            NONE,
            PAUSED,
            PLAYING,
        };

        enum class Mode {
            UNDEFINED,
            NONE,
            MASTER,
            SLAVE,
        };

        enum class SyncLevel {
            UNDEFINED,
            NOSYNC,
            WEAK,
            STRONG,
        };

        struct Audio {
            enum class State {
                IDLE,
                BUFFERING,
                PLAYING,
                PAUSED,
                STOPPED,
                FINISHED,
                FAILED,
            };

            int32_t offsetMs{0};
            int32_t playedMs{0};
            int32_t durationMs{0};
            int64_t lastPlayTimestamp{0};
            int64_t lastStopTimestamp{0};
            State state{State::IDLE};
            std::string streamId;
            std::string streamType;
            std::string title;
            std::string subtitle;
            std::map<std::string, std::string> scenarioMeta;

            std::string stateName() const;
        };

        struct Music {
            std::string trackId;
            std::string trackInfoJson;
            std::string uid;
            std::string sessionId;
            int64_t timestampMs;
            bool paused{true};
        };

        struct Broadcast {
            std::string masterDeviceId;
            int64_t sessionTimestampMs{0};
            std::string multiroomToken;
            std::vector<std::string> clusterDeviceIds;
            std::string vinsRequestId;
            std::string multiroomTrackId;
            PlayingState playingState{PlayingState::NONE};
            std::shared_ptr<const Audio> audio;
            std::shared_ptr<const Music> music;
        };

        struct Peer {
            std::string deviceId;
            std::string ipAddress;

            bool operator==(const Peer& other) const;
        };

        std::string deviceId;
        std::string ipAddress;
        Mode mode{Mode::UNDEFINED};
        SyncLevel slaveSyncLevel{SyncLevel::UNDEFINED};
        bool slaveClockSyncing{false};
        std::vector<Peer> peers;
        std::vector<std::string> dialogDeviceIds;
        std::shared_ptr<const Broadcast> broadcast;
        uint32_t seqnum{0};
        std::vector<std::string> legacyDeviceIds; // ALICE-19341 For JBL 80 version compatibility

        std::string multiroomSessionId() const;
        std::string multiroomTrackId() const;
        static const char* modeName(Mode /*mode*/);
    };

    class IMultiroomProvider {
    public:
        virtual ~IMultiroomProvider() = default;

        using IMultiroomState = ILiveData<std::shared_ptr<const MultiroomState>>;
        virtual IMultiroomState& multiroomState() = 0;
    };

    std::string makeMultiroomSessionId(std::string_view deviceId, std::string_view multiroomToken, int64_t sessionTimestampMs);
    std::string makeMultiroomTrackId(std::string_view url, int64_t basetime, int64_t position);
    std::string makeMultiroomToken(std::string vinsRequestId);

} // namespace quasar
