#pragma once

#include <yandex_io/interfaces/multiroom/i_multiroom_provider.h>

#include <yandex_io/libs/signals/live_data.h>
#include <yandex_io/protos/quasar_proto.pb.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace quasar::mock {

    class MultiroomProvider: public quasar::IMultiroomProvider {
    public:
        MultiroomProvider()
            : multiroomState_(std::make_shared<MultiroomState>())
        {
        }

        void setMultiroomState(MultiroomState ms)
        {
            multiroomState_ = std::make_shared<MultiroomState>(std::move(ms));
        }

    public:
        IMultiroomState& multiroomState() override {
            return multiroomState_;
        }

    private:
        LiveData<IMultiroomState> multiroomState_;
    };

} // namespace quasar::mock
