#pragma once

#include <yandex_io/interfaces/spectrogram_animation/i_spectrogram_animation_provider.h>

#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/signals/live_data.h>
#include <yandex_io/protos/model_objects.pb.h>

namespace quasar {

    class SpectrogramAnimationProvider: public ISpectrogramAnimationProvider {
    public:
        SpectrogramAnimationProvider(std::shared_ptr<ipc::IIpcFactory> ipcFactory);
        SpectrogramAnimationProvider(std::shared_ptr<ipc::IConnector> connector); // Only for tests purpose

    public: // ISpectrogramAnimationProvider
        ISpectrogramAnimationState& spectrogramAnimationState() override;
        void setExternalPresets(const std::string& configs, const std::string& current, const std::string& extraData) override;

    private:
        Lifetime lifetime_;
        const std::shared_ptr<ipc::IConnector> connector_;
        LiveData<ISpectrogramAnimationState> spectrogramAnimationState_;
    };

} // namespace quasar
