#pragma once

#include <yandex_io/libs/signals/i_live_data.h>
#include <yandex_io/libs/signals/i_signal.h>

#include <json/json.h>

namespace quasar {

    struct SpectrogramAnimationState {
        enum class Source {
            LOCAL,
            EXTERNAL,
        };

        Source source{Source::LOCAL};
        std::string configs;
        std::string current;
        std::string extraData;

        bool operator==(const SpectrogramAnimationState& other) const;
        bool operator!=(const SpectrogramAnimationState& other) const;
    };
    using SpectrogramAnimationStatePtr = std::shared_ptr<SpectrogramAnimationState>;
    using SpectrogramAnimationStateConstPtr = std::shared_ptr<const SpectrogramAnimationState>;
    using ISpectrogramAnimationState = ILiveData<SpectrogramAnimationStateConstPtr>;

    class ISpectrogramAnimationProvider {
    public:
        virtual ~ISpectrogramAnimationProvider() = default;

        virtual ISpectrogramAnimationState& spectrogramAnimationState() = 0;
        virtual void setExternalPresets(const std::string& configs, const std::string& current, const std::string& extraData) = 0;
    };

} // namespace quasar
