#pragma once

#include <yandex_io/interfaces/spectrogram_animation/i_spectrogram_animation_provider.h>

#include <yandex_io/libs/signals/live_data.h>
#include <yandex_io/protos/quasar_proto.pb.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace quasar::mock {

    class SpectrogramAnimationProvider: public ISpectrogramAnimationProvider {
    public:
        SpectrogramAnimationProvider()
            : spectrogramAnimationState_(std::make_shared<SpectrogramAnimationState>())
        {
        }

        void setSpectrogramAnimationState(SpectrogramAnimationState state)
        {
            spectrogramAnimationState_ = std::make_shared<SpectrogramAnimationState>(std::move(state));
        }

    public:
        ISpectrogramAnimationState& spectrogramAnimationState() override {
            return spectrogramAnimationState_;
        }
        MOCK_METHOD(void, setExternalPresets, (const std::string&, const std::string&, const std::string&), (override));

    private:
        LiveData<ISpectrogramAnimationState> spectrogramAnimationState_;
    };

} // namespace quasar::mock
