#pragma once
#include <yandex_io/interfaces/stereo_pair/i_stereo_pair_provider.h>

#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/signals/live_data.h>
#include <yandex_io/libs/signals/signal.h>
#include <yandex_io/libs/signals/signal_external.h>
#include <yandex_io/protos/model_objects.pb.h>

namespace quasar {

    class StereoPairProvider: public IStereoPairProvider {
    public:
        StereoPairProvider(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<ipc::IIpcFactory> ipcFactory);
        StereoPairProvider(std::string myDeviceId, std::shared_ptr<ipc::IConnector> connector); // Only for tests purpose

    public: // IStereoPairProvider
        IStereoPairState& stereoPairState() override;
        IInitialPairingSignal& initialPairingSignal() override;
        IUserEventSignal& userEventSignal() override;
        void userEvent(const std::string& id, const Json::Value& payload) override;
        void speakNotReadyNotification(NotReadyReason notReadyReason) override;
        void overrideChannel(StereoPairState::Channel channel) override;
        void startConversationOnLeader() override;
        void stopConversationOnLeader() override;
        void toggleConversationOnLeader() override;
        void finishConversationOnLeader() override;

    private:
        void updateStereoPairState(const proto::StereoPair::State& state);

    private:
        Lifetime lifetime_;
        const std::string myDeviceId_;
        const std::shared_ptr<ipc::IConnector> connector_;
        LiveData<IStereoPairState> stereoPairState_;
        SignalExternal<IInitialPairingSignal> initialPairingSignal_;
        Signal<IUserEventSignal> userEventSignal_;
    };

} // namespace quasar
