#include "i_stereo_pair_provider.h"

using namespace quasar;

bool StereoPairState::operator==(const StereoPairState& other) const {
    return role == other.role &&
           channel == other.channel &&
           partnerDeviceId == other.partnerDeviceId &&
           connectivity == other.connectivity &&
           stereoPlayerStatus == other.stereoPlayerStatus &&
           initialPairingTimepoint == other.initialPairingTimepoint &&
           spectrogramAnimationState == other.spectrogramAnimationState &&
           volumeManagerState == other.volumeManagerState;
}

bool StereoPairState::operator!=(const StereoPairState& other) const {
    return !(*this == other);
}

bool StereoPairState::isStereoPair() const {
    return role == Role::LEADER || role == Role::FOLLOWER;
}

bool StereoPairState::isFollower() const {
    return role == Role::FOLLOWER;
}

const char* StereoPairState::roleName(Role role)
{
    switch (role) {
        case Role::UNDEFINED:
            return "UNDEFINED";
        case Role::STANDALONE:
            return "STANDALONE";
        case Role::LEADER:
            return "LEADER";
        case Role::FOLLOWER:
            return "FOLLOWER";
    }
    throw std::runtime_error("Unexpected StereoPairState Role enum");
}

const char* StereoPairState::channelName(Channel channel)
{
    switch (channel) {
        case Channel::ALL:
            return "all";
        case Channel::LEFT:
            return "left";
        case Channel::RIGHT:
            return "right";
        case Channel::UNDEFINED:
            break;
    }
    return "undefined";
}

const char* StereoPairState::connectivityName(Connectivity connectivity) {
    switch (connectivity) {
        case Connectivity::UNDEFINED:
            return "UNDEFINED";
        case Connectivity::INAPPLICABLE:
            return "INAPPLICABLE";
        case Connectivity::NO_CONNECTION:
            return "NO_CONNECTION";
        case Connectivity::ONEWAY:
            return "ONEWAY";
        case Connectivity::TWOWAY:
            return "TWOWAY";
    };
    return "wrong";
}

const char* StereoPairState::stereoPlayerStatusName(StereoPlayerStatus stereoPlayerStatus)
{
    switch (stereoPlayerStatus) {
        case StereoPlayerStatus::UNDEFINED:
            return "UNDEFINED";
        case StereoPlayerStatus::NO_SYNC:
            return "NO_SYNC";
        case StereoPlayerStatus::PARTNER_NOT_READY:
            return "PARTNER_NOT_READY";
        case StereoPlayerStatus::READY:
            return "READY";
    }
    throw std::runtime_error("Unexpected StereoPlayerStatus enum");
}

StereoPairState::Channel StereoPairState::parseChannel(std::string_view text)
{
    if (!text.compare("default") || !text.compare("all")) {
        return Channel::ALL;
    } else if (!text.compare("left")) {
        return Channel::LEFT;
    } else if (!text.compare("right")) {
        return Channel::RIGHT;
    } else {
        return Channel::UNDEFINED;
    }
}

IStereoPairProvider::~IStereoPairProvider() = default;
