#pragma once

#include <yandex_io/interfaces/stereo_pair/i_stereo_pair_provider.h>

#include <yandex_io/libs/signals/live_data.h>
#include <yandex_io/protos/quasar_proto.pb.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace quasar::mock {

    class StereoPairProvider: public quasar::IStereoPairProvider {
    public:
        StereoPairProvider()
            : stereoPairState_(std::make_shared<StereoPairState>())
        {
        }

        void setStereoPairState(StereoPairState state)
        {
            stereoPairState_ = std::make_shared<StereoPairState>(std::move(state));
        }

    public:
        IStereoPairState& stereoPairState() override {
            return stereoPairState_;
        }
        MOCK_METHOD(IInitialPairingSignal&, initialPairingSignal, (), (override));
        MOCK_METHOD(IUserEventSignal&, userEventSignal, (), (override));
        MOCK_METHOD(void, userEvent, (const std::string&, const Json::Value&), (override));
        MOCK_METHOD(void, speakNotReadyNotification, (NotReadyReason), (override));
        MOCK_METHOD(void, overrideChannel, (StereoPairState::Channel), (override));

        MOCK_METHOD(void, startConversationOnLeader, (), (override));
        MOCK_METHOD(void, stopConversationOnLeader, (), (override));
        MOCK_METHOD(void, toggleConversationOnLeader, (), (override));
        MOCK_METHOD(void, finishConversationOnLeader, (), (override));

    private:
        LiveData<IStereoPairState> stereoPairState_;
    };

} // namespace quasar::mock
