#pragma once

#include <yandex_io/interfaces/updates/i_updates_provider.h>

#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/signals/live_data.h>
#include <yandex_io/libs/signals/signal_external.h>
#include <yandex_io/protos/quasar_proto_forward.h>

#include <list>

namespace quasar {

    class UpdatesProvider: public IUpdatesProvider {
    public:
        UpdatesProvider(std::shared_ptr<ipc::IIpcFactory> ipcFactory);
        UpdatesProvider(std::shared_ptr<ipc::IConnector> updatesdConnector, std::shared_ptr<ICallbackQueue> callbackQueue); // For testing purpose only!

        ~UpdatesProvider();

    public: // IUpdatesProvider
        IUpdatesState& updatesState() override;
        IReadyApplyUpdateSignal& readyApplyUpdateSignal() override;
        void checkUpdates() override;
        void confirmUpdateApply() override;
        void postponeUpdateApply() override;
        void waitUpdateState(std::function<void(UpdatesState2::Critical)> callback, std::chrono::milliseconds timeout) override;

    private:
        void onQuasarMessage(const ipc::SharedMessage& message);

    private:
        Lifetime lifetime_;
        const std::shared_ptr<ipc::IConnector> updatesdConnector_;
        const std::shared_ptr<ICallbackQueue> callbackQueue_;

        SignalExternal<IReadyApplyUpdateSignal> readyApplyUpdateSignal_;

        std::mutex mutex_;
        LiveData<IUpdatesState> updatesState_;
        struct AwaitingCallbacks {
            std::function<void(UpdatesState2::Critical)> callback;
            std::chrono::steady_clock::time_point expired;
        };
        std::list<AwaitingCallbacks> awaitingCallbacks_;
    };

} // namespace quasar
