#pragma once
#include <yandex_io/libs/signals/i_live_data.h>

#include <chrono>
#include <optional>

namespace quasar {

    struct UpdatesState2 {
        enum class Progress {
            UNDEFINED,
            NONE,
            DOWNLOADING,
            APPLYING,
        };

        enum class Critical {
            UNDEFINED,
            YES,
            NO,
        };

        Progress progress{Progress::UNDEFINED};
        Critical critical{Critical::UNDEFINED};
        bool readyToApplyUpdateFlag{false};

        bool operator==(const UpdatesState2& other) const;
        bool operator!=(const UpdatesState2& other) const;
    };

    class IUpdatesProvider {
    public:
        virtual ~IUpdatesProvider() = default;

        using IUpdatesState = ILiveData<std::shared_ptr<const UpdatesState2>>;
        virtual IUpdatesState& updatesState() = 0;

        /**
         * @brief Signal when updater ready to apply new update
         */
        using IReadyApplyUpdateSignal = ISignal<bool>;
        virtual IReadyApplyUpdateSignal& readyApplyUpdateSignal() = 0;

        /**
         * @brief Ping updatesd with check_updates message, so Updatesd will check updates asap
         */
        virtual void checkUpdates() = 0;

        /**
         * @brief Confirm that Updater can apply update without timeout (instantly)
         */
        virtual void confirmUpdateApply() = 0;

        /**
         * @brief Send request to postpone update apply
         * @note: Updatesd will ignore postpone if hard deadline exceeded
         */
        virtual void postponeUpdateApply() = 0;

        /**
         * @brief Async send check_updates to updatesd and execute callback when get result or timeout
         * @param[in] timeout How long to wait until receive update state. execute callback with UpdatesState::Critical::UNDEFINED if timed out
         */
        virtual void waitUpdateState(std::function<void(UpdatesState2::Critical)>, std::chrono::milliseconds timeout) = 0;
    };

} // namespace quasar
