#pragma once

#include <yandex_io/interfaces/updates/i_updates_provider.h>

#include <yandex_io/libs/logging/logging.h>
#include <yandex_io/libs/signals/live_data.h>
#include <yandex_io/libs/signals/signal.h>

namespace quasar::mock {

    class UpdatesProvider: public IUpdatesProvider {
    public:
        UpdatesProvider()
            : UpdatesProvider(UpdatesState2{})
        {
        }

        UpdatesProvider(UpdatesState2 updatesState)
        {
            setUpdatesState(updatesState);
        }

        void setUpdatesState(UpdatesState2 updatesState)
        {
            std::lock_guard ldLock(updatesState_);
            auto us = updatesState_.value();
            updatesState_ = std::make_shared<UpdatesState2>(updatesState);
            if (!us || us->readyToApplyUpdateFlag != updatesState.readyToApplyUpdateFlag) {
                readyApplyUpdateSignal_(updatesState.readyToApplyUpdateFlag);
            }
        }

        void setCheckUpdates(std::function<void()> f) {
            checkUpdates_ = f;
        }
        void setConfirmUpdateApply(std::function<void()> f) {
            confirmUpdateApply_ = f;
        }
        void setPostponeUpdateApply(std::function<void()> f) {
            postponeUpdateApply_ = f;
        }
        void setWaitUpdateState(std::function<UpdatesState2::Critical()> answer) {
            waitUpdateState_ = std::move(answer);
        }

    public: // IUpdatesProvider
        IUpdatesState& updatesState() override {
            return updatesState_;
        }
        IReadyApplyUpdateSignal& readyApplyUpdateSignal() override {
            return readyApplyUpdateSignal_;
        }
        void checkUpdates() override {
            if (!checkUpdates_) {
                YIO_LOG_WARN("Unexpected call of IUpdatesProvider.checkUpdates");
                abort();
            }
            checkUpdates_();
        }
        void confirmUpdateApply() override {
            if (!confirmUpdateApply_) {
                YIO_LOG_WARN("Unexpected call of IUpdatesProvider.confirmUpdateApply");
                abort();
            }
            confirmUpdateApply_();
        }
        void postponeUpdateApply() override {
            if (!postponeUpdateApply_) {
                YIO_LOG_WARN("Unexpected call of IUpdatesProvider.postponeUpdateApply");
                abort();
            }
            postponeUpdateApply_();
        }
        void waitUpdateState(std::function<void(UpdatesState2::Critical)> callback, std::chrono::milliseconds /*timeout*/) override {
            if (!waitUpdateState_) {
                YIO_LOG_WARN("Unexpected call of IUpdatesProvider.waitUpdateState");
                abort();
            }
            callback(waitUpdateState_());
        }

    private:
        Signal<IReadyApplyUpdateSignal> readyApplyUpdateSignal_;
        LiveData<IUpdatesState> updatesState_;
        std::function<UpdatesState2::Critical()> waitUpdateState_;
        std::function<void()> checkUpdates_;
        std::function<void()> confirmUpdateApply_;
        std::function<void()> postponeUpdateApply_;
    };

} // namespace quasar::mock
