#pragma once

#include <yandex_io/interfaces/user_config/i_user_config_provider.h>

#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/signals/live_data.h>
#include <yandex_io/libs/signals/signal_external.h>
#include <yandex_io/protos/quasar_proto_forward.h>

namespace quasar {

    class UserConfigProvider: public IUserConfigProvider {
    public:
        UserConfigProvider(std::shared_ptr<ipc::IIpcFactory> ipcFactory);
        UserConfigProvider(std::shared_ptr<ipc::IConnector> connector); // For testing purpose only!
        ~UserConfigProvider();

    public: // IUserConfigProvider
        IUserConfig& userConfig() override;
        IJsonChangedSignal& jsonChangedSignal(ConfigScope configScope, const std::string& xpath) override;
        IAccountDevicesChangedSignal& accountDevicesChangedSignal() override;

    protected:
        bool setUserConfig(std::shared_ptr<UserConfig> newUserConfig);

    private:
        void onQuasarMessage(const ipc::SharedMessage& message);
        void notifyJsonChanges(const std::shared_ptr<const UserConfig>& oldUserConfig, const std::shared_ptr<const UserConfig>& newUserConfig);
        void notifyAllJsonChanges();

    private:
        Lifetime lifetime_;
        const std::shared_ptr<ipc::IConnector> syncdConnector_;
        LiveData<IUserConfig> userConfig_;
        SignalExternal<IAccountDevicesChangedSignal> accountDevicesChangedSignal_;

        std::mutex mutex_;
        std::map<std::pair<ConfigScope, std::string>, std::shared_ptr<SignalExternal<IJsonChangedSignal>>> xpathSignals_;
    };

} // namespace quasar
