#pragma once
#include <yandex_io/libs/signals/i_live_data.h>

#include <json/value.h>

#include <chrono>
#include <vector>

namespace quasar {

    struct AccountDevice {
        std::string deviceId;
        std::string platform;
        std::string name;
        std::string serverCertificate;
        std::string serverPrivateKey;

        bool operator==(const AccountDevice& other) const;
        bool operator!=(const AccountDevice& other) const;
    };

    struct UserConfig {
        enum class Auth {
            UNDEFINED,
            FAILED,
            SUCCESS
        };
        Auth auth{Auth::UNDEFINED};
        std::string passportUid;
        Json::Value account;
        Json::Value device;
        Json::Value system;
        Json::Value auxiliary;
        std::string subscriptionInfo;
        std::chrono::system_clock::time_point updateTime;
        std::vector<AccountDevice> accountDevices;

        Json::Value merged(const std::string& xpath) const;

        bool operator==(const UserConfig& other) const;
        bool operator!=(const UserConfig& other) const;
    };

    class IUserConfigProvider {
    public:
        virtual ~IUserConfigProvider() = default;

        using IUserConfig = ILiveData<std::shared_ptr<const UserConfig>>;
        virtual IUserConfig& userConfig() = 0;

        enum class ConfigScope {
            ACCOUNT,
            DEVICE,
            SYSTEM,
            AUXILIARY,

            MERGED,
        };
        using IJsonChangedSignal = ISignal<std::shared_ptr<const Json::Value>>;
        virtual IJsonChangedSignal& jsonChangedSignal(ConfigScope, const std::string& xpath) = 0;

        using IAccountDevicesChangedSignal = ISignal<std::shared_ptr<const std::vector<AccountDevice>>>;
        virtual IAccountDevicesChangedSignal& accountDevicesChangedSignal() = 0;
    };

} // namespace quasar
