#pragma once

#include <yandex_io/interfaces/user_config/connector/user_config_provider.h>

namespace quasar::mock {

    class UserConfigProvider: public quasar::UserConfigProvider {
    public:
        UserConfigProvider(std::nullptr_t)
            : quasar::UserConfigProvider(std::shared_ptr<ipc::IConnector>())
        {
        }

        UserConfigProvider(UserConfig userConfig)
            : quasar::UserConfigProvider(std::shared_ptr<ipc::IConnector>())
        {
            setUserConfig(std::move(userConfig));
        }

        void setUserConfig(UserConfig userConfig)
        {
            quasar::UserConfigProvider::setUserConfig(std::make_shared<UserConfig>(std::move(userConfig)));
        }
    };

} // namespace quasar::mock
