#pragma once

#include <yandex_io/interfaces/volume_manager/i_volume_manager_provider.h>

#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/signals/live_data.h>
#include <yandex_io/protos/model_objects.pb.h>

namespace quasar {

    class VolumeManagerProvider: public IVolumeManagerProvider {
    public:
        VolumeManagerProvider(std::shared_ptr<ipc::IIpcFactory> ipcFactory);
        VolumeManagerProvider(std::shared_ptr<ipc::IConnector> connector); // Only for tests purpose

    public: // IVolumeManagerProvider
        IVolumeManagerState& volumeManagerState() override;
        void setPlatformVolume(int platformVolume, bool isMuted, const std::string& source) override;
        void setAliceVolume(int aliceVolume, bool isMuted, const std::string& source) override;

    private:
        Lifetime lifetime_;
        const std::shared_ptr<ipc::IConnector> connector_;
        LiveData<IVolumeManagerState> volumeManagerState_;
    };

} // namespace quasar
