#pragma once
#include <yandex_io/libs/signals/i_live_data.h>
#include <yandex_io/libs/signals/i_signal.h>

#include <optional>

namespace quasar {

    struct VolumeManagerState {
        int platformVolume{0};
        int aliceVolume{0};
        bool isMuted{false};
        std::string source;
        bool setBtVolume{false};

        bool operator==(const VolumeManagerState& other) const;
        bool operator!=(const VolumeManagerState& other) const;
    };
    using VolumeManagerStatePtr = std::shared_ptr<VolumeManagerState>;
    using VolumeManagerStateConstPtr = std::shared_ptr<const VolumeManagerState>;
    using IVolumeManagerState = ILiveData<VolumeManagerStateConstPtr>;

    class IVolumeManagerProvider {
    public:
        virtual ~IVolumeManagerProvider() = default;

        virtual IVolumeManagerState& volumeManagerState() = 0;

        virtual void setPlatformVolume(int platformVolume, bool isMuted, const std::string& source) = 0;
        virtual void setAliceVolume(int aliceVolume, bool isMuted, const std::string& source) = 0;
    };

} // namespace quasar
