#pragma once

#include <yandex_io/interfaces/volume_manager/i_volume_manager_provider.h>

#include <yandex_io/libs/signals/live_data.h>
#include <yandex_io/protos/quasar_proto.pb.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace quasar::mock {

    class VolumeManagerProvider: public quasar::IVolumeManagerProvider {
    public:
        VolumeManagerProvider()
            : volumeManagerState_(std::make_shared<VolumeManagerState>())
        {
        }

        void setVolumeManagerState(VolumeManagerState state)
        {
            volumeManagerState_ = std::make_shared<VolumeManagerState>(std::move(state));
        }

    public:
        IVolumeManagerState& volumeManagerState() override {
            return volumeManagerState_;
        }
        MOCK_METHOD(void, setPlatformVolume, (int, bool, const std::string&), (override));
        MOCK_METHOD(void, setAliceVolume, (int, bool, const std::string&), (override));

    private:
        LiveData<IVolumeManagerState> volumeManagerState_;
    };

} // namespace quasar::mock
