#pragma once

#include <yandex_io/libs/activity_tracker/interface/i_activity.h>

#include <yandex_io/libs/logging/logging.h>

#include <deque>
#include <memory>
#include <vector>

namespace YandexIO {

    class ActivityTracker {
    public:
        class Listener {
        public:
            virtual ~Listener() = default;
            virtual void onActivityAdded(const IActivityConstPtr&) = 0;
            virtual void onActivityRemoved(const IActivityConstPtr&) = 0;
        };
        virtual ~ActivityTracker() = default;

        void clear();
        virtual bool addActivity(const IActivityPtr& activity);
        virtual bool removeActivity(const IActivityPtr& activity);
        virtual std::optional<quasar::proto::AudioChannel> getCurrentFocusChannel() const;

        void addListener(std::shared_ptr<Listener> listener);
        void removeListener(std::shared_ptr<Listener> listener);

    private:
        IActivityPtr findNextForegroundActivity(quasar::proto::AudioChannel channel) const;
        bool isTopPriorityChannel(quasar::proto::AudioChannel channel) const;
        void setForegroundActivity(const IActivityPtr& value);
        std::string formatCurrentFocusChannel() const;
        IActivityPtr getFirstActivityStartingFrom(quasar::proto::AudioChannel channel) const;

    private:
        using ActivityQueue = std::deque<IActivityPtr>;

        std::optional<quasar::proto::AudioChannel> currentFocusChannel_;
        std::vector<ActivityQueue> channels_{quasar::proto::AudioChannel_ARRAYSIZE};
        std::set<std::shared_ptr<Listener>> listeners_;
    };

} // namespace YandexIO
