#pragma once

#include <yandex_io/libs/activity_tracker/interface/i_activity.h>

namespace YandexIO {
    class ChannelActivity: public YandexIO::IActivity {
    public:
        ChannelActivity(std::string name, quasar::proto::AudioChannel channel, bool isLocal);

        std::string activityName() const override;
        void setBackground() override;
        void setForeground() override;
        quasar::proto::AudioChannel getAudioChannel() const override;
        bool isLocal() const override;

    private:
        const std::string name_;
        const quasar::proto::AudioChannel channel_;
        const bool isLocal_;
    };

    using ChannelActivityPtr = std::shared_ptr<ChannelActivity>;

} // namespace YandexIO
