#pragma once

#include <yandex_io/protos/model_objects.pb.h>

#include <memory>

namespace YandexIO {

    class IActivity {
        // default Activity state is background
    public:
        virtual ~IActivity();

        virtual std::string activityName() const = 0;
        virtual void setBackground() = 0;
        virtual void setForeground() = 0;
        virtual quasar::proto::AudioChannel getAudioChannel() const = 0;
        virtual bool isLocal() const = 0;
    };

    using IActivityPtr = std::shared_ptr<IActivity>;
    using IActivityConstPtr = std::shared_ptr<const IActivity>;

} // namespace YandexIO
