#include "init.h"

#include <SLES/OpenSLES.h>
#include <SLES/OpenSLES_Android.h>

#include <sstream>

namespace {
    void throw_runtime_error(const std::string& file, const std::string& function, unsigned line,
                             const std::string& message) {
        std::stringstream stream{};
        stream << file << '(' << function << ')' << ':' << line << ": " << message;
        throw std::runtime_error{stream.str()};
    }

#define THROW_RUNTIME_ERROR(message) throw_runtime_error(__FILE__, __func__, __LINE__, (message))
#define THROW_IF(expr)                  \
    do {                                \
        if (expr) {                     \
            THROW_RUNTIME_ERROR(#expr); \
        }                               \
    } while (false)

    SLObjectItf createEngineObject() {
        SLObjectItf engineObject = nullptr;
        auto error = slCreateEngine(&engineObject, 0, nullptr, 0, nullptr, nullptr);
        THROW_IF(error != SL_RESULT_SUCCESS);
        THROW_IF(engineObject == nullptr);
        THROW_IF(*engineObject == nullptr);
        return engineObject;
    }

    void destroyEngine(const SLObjectItf engineObject) {
        THROW_IF(engineObject == nullptr);
        THROW_IF(*engineObject == nullptr);
        (*engineObject)->Destroy(engineObject);
    }
}

void android_support::initializeOpenSLES() {
    destroyEngine(createEngineObject());
}
