#pragma once

#include <string>

namespace android_support {
    std::string getSystemProperty(const char* name);

    void setSystemProperty(const char* name, const char* value);

    inline std::string getSystemProperty(const std::string& name) {
        return getSystemProperty(name.c_str());
    }

    inline void setSystemProperty(const std::string& name, const std::string& value) {
        setSystemProperty(name.c_str(), value.c_str());
    }
} // namespace android_support
