#pragma once

#include "report_configuration.h"
#include "typedefs.h"

#include <yandex_io/libs/appmetrica/proto/metrica.pb.h>

#include <yandex_io/libs/metrica/base/events_database.h>
#include <yandex_io/libs/metrica/base/metrica_session_provider.h>
#include <yandex_io/libs/threading/blocking_queue.h>
#include <yandex_io/libs/counters/default_daily_counter.h>

#include <json/json.h>

#include <functional>
#include <map>
#include <memory>
#include <queue>
#include <random>
#include <shared_mutex>
#include <string>
#include <utility>

class AppMetricaClient {
public:
    AppMetricaClient(std::shared_ptr<quasar::EventsDatabase> db,
                     std::shared_ptr<blockingQueue> immediateQueue,
                     std::string sessionIdPersistentPath,
                     std::string sessionIdTemporaryPath);

    void reportEvent(const std::string& eventName, const std::string& eventValue, bool skipDatabase = false);
    void reportError(const std::string& errorEventName, bool skipDatabase = false, const std::string& errorValue = "");
    /**
     * @brief add EVENT_START to immediateQueue_, so default session will start.
     * NOTE: Now it is a workaround to enable user location on Quasar Charts.
     */
    void startSession();
    void putEnvironmentVariable(const std::string& variableName, const std::string& variableValue);
    void deleteEnvironmentVariable(const std::string& variableName);
    void setUserInfo(const std::string& userId);
    void setConnectionType(quasar::proto::ConnectionType newValue);

    bool shouldProcessEvent(const std::string& eventName);
    void updateEventBlacklist(const Json::Value& eventBlacklist);

    Json::Value getStatsPayload();

private:
    static uint64_t getNowInSeconds();
    void reportEventImmediate(const std::string& eventName, const std::string& eventValue, ReportMessage::Session::Event::EventType eventType);
    void reportEventOverDb(const std::string& eventName, const std::string& eventValue, quasar::proto::DatabaseMetricaEvent::NewEvent::Type eventType);

    std::map<std::string, std::string> environmentVariables_;
    std::string userId_;
    std::shared_ptr<quasar::EventsDatabase> db_;
    std::shared_ptr<blockingQueue> immediateQueue_;
    MetricaSessionProvider sessionProvider_;

    std::shared_mutex eventBlacklistMutex_;
    std::mutex envVariablesMapMutex_;
    std::unordered_set<std::string> eventBlacklist_;
    std::atomic<quasar::proto::ConnectionType> connectionType_{quasar::proto::CONNECTION_TYPE_UNKNOWN};

    enum Counters {
        TOTAL,
        IMMEDIATE_DROP,
        DBFAIL_DROP,
        BLACKLIST,
        MAX_
    };
    quasar::DefaultDailyCounter<Counters> dailyStats_;
};
