#pragma once

#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/http_client/http_client.h>
#include <yandex_io/libs/appmetrica/proto/metrica.pb.h>

class AppMetricaSenderBase {
public:
    AppMetricaSenderBase(std::shared_ptr<YandexIO::IDevice> device);
    AppMetricaSenderBase(std::shared_ptr<YandexIO::IDevice> device, bool keepAlive);
    //! return true if report was successfully sent
    bool trySendReport(ReportMessage report, const std::vector<std::string>& hosts);

private:
    bool sendPostRequest(const std::string& url, const std::string& payload);

    quasar::HttpClient httpClient_;
};
