#pragma once

#include "report_configuration.h"
#include <json/json.h>

#include <string>

namespace quasar {

    struct MetricaMetadata {
        std::string UUID;
        std::string deviceID;

        bool operator==(const MetricaMetadata&) const = default;

        Json::Value toJson() const;
        void saveMetadata(const std::string& filepath) const;

        static MetricaMetadata fromJson(const Json::Value& json);
        static MetricaMetadata fromReportConfig(const ReportConfiguration& reportConfig);
        static MetricaMetadata loadMetadata(const std::string& filepath);
    };
} // namespace quasar
