#include "report_configuration.h"

#include <yandex_io/libs/logging/logging.h>
#include <yandex_io/libs/metrica/base/utils.h>

std::string ReportConfiguration::reportRequestURL(const std::string& reportHost) const {
    std::ostringstream url;
    url << reportHost << "/report";
    url << "?protocol_version=2";
    url << "&locale=ru_RU";
    url << "&query_hosts=2";

    url << "&analytics_sdk_build_type=" << urlencode(analyticsSdkBuildType_);
    url << "&analytics_sdk_version_name=" << urlencode(analyticsSdkVersionName_);
    url << "&api_key_128=" << urlencode(apiKey_);
    url << "&app_id=" << urlencode(metricaAppID_);
    url << "&app_platform=" << urlencode(appPlatform_);
    url << "&app_version_name=" << urlencode(appVersionName_);
    url << "&device_type=" << urlencode(deviceType_);
    url << "&manufacturer=" << urlencode(manufacturer_);
    url << "&model=" << urlencode(model_);
    url << "&os_version=" << urlencode(osVersion_);

    url << "&deviceid=" << urlencode(deviceID_);
    url << "&uuid=" << urlencode(UUID_);

    YIO_LOG_TRACE("Report URL: " << url.str());
    return url.str();
}

ReportConfiguration::ReportConfiguration(const std::time_t& _startTime, const std::vector<std::string>& reportHosts,
                                         YandexIO::IDevice& device)
    : startTime_(_startTime)
    , reportHosts_(reportHosts)
    , deviceID_(device.deviceId())
    , model_(device.configuration()->getDeviceType())
    , metricaAppID_(device.configuration()->getCommonConfig()["metricaAppId"].asString())
{
}

const std::vector<std::string>& ReportConfiguration::reportHosts() const {
    return reportHosts_;
}

std::vector<std::string> ReportConfiguration::reportRequestURLS() const {
    std::vector<std::string> urls;
    urls.reserve(reportHosts_.size());
    for (const std::string& reportHost : reportHosts_) {
        urls.push_back(reportRequestURL(reportHost));
    }
    return urls;
}

ReportConfiguration::ReportConfiguration(const std::time_t& _startTime, const std::vector<std::string>& _reportHosts,
                                         const StartupConfiguration& startupConfiguration, const std::string& UUID, const std::string& deviceID)
    : startTime_(_startTime)
    , reportHosts_(_reportHosts)
    , deviceID_(deviceID)
    , UUID_(UUID)
    , model_(startupConfiguration.model)
    , appVersion_(startupConfiguration.appVersion)
    , appVersionName_(startupConfiguration.appVersionName)
    , manufacturer_(startupConfiguration.manufacturer)
    , osVersion_(startupConfiguration.osVersion)
    , metricaAppID_(startupConfiguration.metricaAppID)
    , deviceType_(startupConfiguration.deviceType)
    , appPlatform_(startupConfiguration.appPlatform)
    , apiKey_(startupConfiguration.apiKey)
    , revision_(startupConfiguration.revision)
{
}

const std::string& ReportConfiguration::getDeviceId() const {
    return deviceID_;
}

const std::string& ReportConfiguration::getUuid() const {
    return UUID_;
}

const std::string& ReportConfiguration::getDeviceType() const {
    return deviceType_;
}

const std::string& ReportConfiguration::getModel() const {
    return model_;
}

const std::string& ReportConfiguration::getRevision() const {
    return revision_;
}
